
/*! \file DX_VOS_config.h
    \brief This file defines the options for using 64bits variables
*/


#ifndef _DX_VOS_CONFIG_H
#define _DX_VOS_CONFIG_H

#define NO_OS

#ifndef __FUNCTION__
#define __FUNCTION__ ""
#endif

#define LITTLE__ENDIAN
#define HASLONGLONG
#define DX_VOS_PATH_DIVIDER		"/" 
#define DX_VOS_DEFAULT_ROOT		"/" 
#define DX_VOS_DRM_ROOT_PATH	"/shared"

#define DX_VOS_MAX_PATH 260

#ifdef  __cplusplus
#define DX_ADDRESSOF(v)   ( &reinterpret_cast<const char &>(v) )
#else
#define DX_ADDRESSOF(v)   ( &(v) )
#endif
#define DX_INTSIZEOF(n)   ( (sizeof(n) + sizeof(int) - 1) & ~(sizeof(int) - 1) )

typedef char * DX_VA_LIST;

#define DX_VA_START(ap,v)  ( ap = (DX_VA_LIST)DX_ADDRESSOF(v) + DX_INTSIZEOF(v) )
#define DX_VA_ARG(ap,t)    ( *(t *)((ap += DX_INTSIZEOF(t)) - DX_INTSIZEOF(t)) )
#define DX_VA_END(ap)      ( ap = (DX_VA_LIST)0 )

#ifndef IMPORT_C
#define IMPORT_C
#endif
#ifndef EXPORT_C
#define EXPORT_C
#endif


#endif /* ifndef _DX_VOS_CONFIG_H*/
